{include file="left.tpl"}

<div class="content float-right">
	<script>
		jQuery(document).ready(function($)
		{
			settings_forum_section();
			settings_forum_groups();
		});

		function settings_forum_section_access(type, id)
		{
			id = id || '';

			if(type == 'all')
			{
				$('#access_'+id+' > label').removeClass('checked');
				$('#access_'+id+' > label > input').removeAttr('checked');
			}else{
				$('#access_'+id+' > #input_'+id+'_all').removeClass('checked');
				$('#access_'+id+' > #input_'+id+'_all > input').removeAttr('checked');
			}

			if($('#input_'+id+'_'+type).hasClass('checked'))
				setTimeout(function() {$('#input_'+id+'_'+type).removeClass('checked'); $('#input_'+id+'_'+type+' > input').removeAttr('checked', '')}, 100);
			else
				setTimeout(function() {$('#input_'+id+'_'+type).addClass('checked'); $('#input_'+id+'_'+type+' > input').attr('checked', '')}, 100);
		}

		function settings_forum_section_position(id, type)
		{
			NProgress.start();

			$.ajax({
				type: 'POST',
				url: '../ajax/actions_z.php',
				data: 'phpaction=1&'+type+'_section=1&token='+$('#token').val()+'&id='+id,
				dataType: 'json',
				success: function(result)
				{
					NProgress.done();

					if(result.status == 1)
					{
						settings_forum_section();

						setTimeout(show_ok, 500);
					}else
						setTimeout(show_error, 500);
				}
			});
		}

		function settings_forum_forums_position(id, section, type)
		{
			NProgress.start();

			$.ajax({
				type: 'POST',
				url: '../ajax/actions_c.php',
				data: 'phpaction=1&'+type+'_forum=1&token='+$('#token').val()+'&id='+id+'&id2='+section,
				dataType: 'json',
				success: function(result)
				{
					NProgress.done();

					if(result.status == 1)
					{
						settings_forum_forums(section);

						setTimeout(show_ok, 500);
					}else
						setTimeout(show_error, 500);
				}
			});
		}

		function settings_forum_section()
		{
			$.ajax({
				type: 'POST',
				url: home+'templates/SquareLine/php/settings_forum_section.php',
				data: 'token='+$('#token').val(),
				success: function(data)
				{
					$('#sections').html(data);
				}
			});

			return null;
		}

		function settings_forum_forums(id)
		{
			$.ajax({
				type: 'POST',
				url: home+'templates/SquareLine/php/settings_forum_forums.php',
				data: 'token='+$('#token').val()+'&id='+id,
				success: function(data)
				{
					$('#settings_forums_'+id).html(data);
				}
			});

			return null;
		}

		function settings_forum_groups()
		{
			$.ajax({
				type: 'POST',
				url: home+'templates/SquareLine/php/settings_forum_groups.php',
				data: 'token='+$('#token').val(),
				success: function(data)
				{
					$('#access_').html(data);
				}
			});

			return null;
		}

		function settings_forum_add_section()
		{
			NProgress.start();

			var data = {}

			data['add_section'] = '1';

			var sec_data = $('#section_settings').serialize();

			$.ajax({
				type: 'POST',
				url: '../ajax/actions_z.php',
				data: create_material(data)+'&'+$('#section_settings').serialize(),
				dataType: 'json',
				success: function(result)
				{
					NProgress.done();

					if(result.status == 1)
					{
						add_block_hide('section');

						setTimeout(show_ok, 500);

						settings_forum_section();
					}else{
						setTimeout(show_error, 500);

						if(result.data != '' & result.data != undefined)
							show_input_error(result.input, result.data, null);
					}
				}
			});
		}

		function settings_forum_add_forum()
		{
			NProgress.start();

			section = encodeURIComponent($('#forum_sections').val());

			$.ajax({
				type: 'POST',
				url: '../ajax/actions_c.php',
				data: 'phpaction=1&add_forum=1&token='+$('#token').val()+'&name='+encodeURIComponent($('#forum_name').val())+'&description='+encodeURIComponent($('#forum_description').val())+'&section='+section+'&img='+encodeURIComponent($('#forum_img').val()),
				dataType: 'json',
				success: function(result)
				{
					NProgress.done();

					if(result.status == 1)
					{
						add_block_hide('forum');

						setTimeout(show_ok, 500);

						settings_forum_forums(section);
					}else{
						setTimeout(show_error, 500);

						show_input_error(result.input, result.reply);
					}
				}
			});
		}

		function add_block_show(block, close)
		{
			add_block_hide(close);

			$('#add_'+block).show();

			return false;
		}

		function add_block_hide(block)
		{
			$('#add_'+block).hide();

			return false;
		}
	</script>

	<? if(strripos($users_groups[$sessionrights]['rights'], "t") !== false){ ?>
		<a class="button-big float-left" href="#" onclick="return add_block_show('section', 'forum')"><i class="fa fa-plus-square"></i> Добавить раздел</a>
		<a class="button-big active float-right" href="#" onclick="load_sections_list(); return add_block_show('forum', 'section')"><i class="fa fa-plus-square"></i> Добавить форум</a>
	<? } ?>

	<div class="clear"></div>

	<div class="block disp-n" id="add_section">
		<div class="header">Добавление раздела</div>
		<div class="block-content">
			<form id="section_settings">
				<div class="form-input">
					<label for="section_name">Название</label>
					<input type="text" name="section_name" id="section_name" maxlength="255">
				</div>
				<div class="form-input">
					<label for="access_">Доступ</label>
					<div id="access_"></div>
				</div>
			</form>

			<div class="clear"></div>

			<div class="space"></div>

			<div class="btn green float-left" onclick="settings_forum_add_section()">Добавить</div>
			<div class="btn float-right" onclick="add_block_hide('section')">Закрыть</div>

			<div class="clear"></div>
		</div>
	</div>

	<div class="block disp-n" id="add_forum">
		<div class="header">Добавление форума</div>
		<div class="block-content">
			<div class="upload-image">
			<img id="image" src="../files/forums_imgs/none.jpg" class="float-left">
			<form enctype="multipart/form-data" action="ajax/actions_c.php" method="post" id="img_form" class="float-right">
				<input type="hidden" id="token" name="token" value="{token}">
				<input type="hidden" id="id" name="id" value="">
				<input type="hidden" id="load_forum_img" name="load_forum_img" value="1">
				<input type="hidden" id="phpaction" name="phpaction" value="1">
				<input class="imginput" type="file" id="img" accept="image/*" name="img">

				<div class="space"></div>

				<div class="btn float-left" onclick="$('#img_form').submit()">Загрузить</div>

				<div id="img_result"></div>
			</form>
		</div>

		<div class="clear"></div>

		<div class="form-input">
			<label for="forum_name{id}">Название</label>
			<input type="text" id="forum_name" maxlength="250" autocomplete="off">
		</div>

		<div class="form-input">
			<label for="forum_description">Описание</label>
			<input type="text" id="forum_description" maxlength="500" autocomplete="off">
		</div>

		<div class="form-input">
			<label for="sections_list">Раздел</label>
			<div id="sections_list"></div>
		</div>

		<div class="message-send">
			<div class="btn green float-left" onclick="settings_forum_add_forum()">Добавить</div>
			<div class="btn float-right" onclick="add_block_hide('forum')">Закрыть</div>
		</div>

		<div class="clear"></div>

		<div class="space"></div>

		<script>
			$('#img_form').submit(function(event)
			{
				NProgress.start();

				event.preventDefault();

				var data = new FormData($('#img_form')[0]);

				$.ajax({
					type: 'POST',
					url: '../ajax/actions_c.php',
					data: data,
					contentType: false,
					processData: false,
				}).done(function (html){
					$('#img_result').html(html);
					$('#img_form')[0].reset();
				});

				NProgress.done();
			});

			$('#settings_forums > div.space').last().hide();
		</script>
		</div>
	</div>

	<div id="sections"></div>

	<div class="clear"></div>
</div>